/******************************************************************************
 *
 * WinARM Demo P0.16 blink 
 *	
 *****************************************************************************/
 
#include "types.h"
#include "LPC214x.h"
#include "config.h"
#include "armVIC.h"

#define IOPINS016 16
/******************************************************************************
 *
 * Function Name: lowInit()
 *
 * Description:
 *    This function starts up the PLL then sets up the GPIO pins before
 *    waiting for the PLL to lock.  It finally engages the PLL and
 *    returns
 *
 * Calling Sequence: 
 *    void
 *
 * Returns:
 *    void
 *
 *****************************************************************************/
static void lowInit(void)
{
	// set PLL multiplier & divisor.
	// values computed from config
	PLLCFG = PLLCFG_MSEL | PLLCFG_PSEL;
	
	// enable PLL
	PLLCON = PLLCON_PLLE;
	PLLFEED = 0xAA;                       // Make it happen.  These two updates
	PLLFEED = 0x55;                       // MUST occur in sequence.
	
	// setup the parallel port pin
	IO0CLR = (1<<IOPINS016);	// clear the ZEROs output
	IO0SET &= ~(1<<IOPINS016);	// set the ONEs output
	IO0DIR =(1<<IOPINS016);	// set the output bit direction
		
	// wait for PLL lock
	while (!(PLLSTAT & PLLSTAT_LOCK))
		continue;
	
	// enable & connect PLL
	PLLCON = PLLCON_PLLE | PLLCON_PLLC;
	PLLFEED = 0xAA;                       // Make it happen.  These two updates
	PLLFEED = 0x55;                       // MUST occur in sequence.
	
	// setup & enable the MAM
	MAMTIM = MAMTIM_CYCLES;
	MAMCR = MAMCR_FULL;
	
	// set the peripheral bus speed
	// value computed from config.h
	VPBDIV = VPBDIV_VALUE;                // set the peripheral bus clock speed
}

/**/
static void sysInit(void)
{
	lowInit();                            // setup clocks and processor port pins
	
	// set the interrupt controller defaults
#if defined(RAM_RUN)
	MEMMAP = MEMMAP_SRAM;                 // map interrupt vectors space into SRAM
#elif defined(ROM_RUN)
	MEMMAP = MEMMAP_FLASH;                // map interrupt vectors space into FLASH
#else
#error RUN_MODE not defined!
#endif

	VICIntEnClear = 0xFFFFFFFF;           // clear all interrupts
	VICIntSelect = 0x00000000;            // clear all FIQ selections
	VICDefVectAddr = (uint32_t)reset;     // point unvectored IRQs to reset()
	}
	
static void _delay(uint32_t N)
{
	for (uint32_t i=0; i<N;i++);
}

int main(void)
{
	sysInit();
	for (;;)
	{
		IO0CLR = (1<<IOPINS016);	// clear the ZEROs output
		_delay(900000);
		IO0SET = (1<<IOPINS016);	// set the ONEs output
		_delay(900000);
	}

	return 0;
}
